/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.AlignmentSupport;
import com.jidesoft.swing.ButtonStyle;
import com.jidesoft.swing.ComponentStateSupport;
import java.awt.Color;
import java.awt.Cursor;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class JideButton
extends JButton
implements Alignable,
ButtonStyle,
ComponentStateSupport,
AlignmentSupport {
    private static final String uiClassID = "JideButtonUI";
    public static final String PROPERTY_ALWAYS_SHOW_HYPERLINK = "alwaysShowHyperlink";
    private boolean _alwaysShowHyperlink = false;
    private int _buttonStyle = 0;
    public static final String CLIENT_PROPERTY_HIDE_POPUPMENU = "JideButton.hidePopupMenu";
    private int _orientation;
    private Color _defaultForeground;
    private Color _rolloverBackground;
    private Color _selectedBackground;
    private Color _pressedBackground;
    private Color _rolloverForeground;
    private Color _selectedForeground;
    private Color _pressedForeground;

    public JideButton() {
        this(null, null);
    }

    public JideButton(Icon icon) {
        this(null, icon);
    }

    public JideButton(String string) {
        this(string, null);
    }

    public JideButton(Action action) {
        this();
        this.setAction(action);
    }

    public JideButton(String string, Icon icon) {
        this.setModel(new DefaultButtonModel());
        this.init(string, icon);
        this.setRolloverEnabled(true);
        this.setFocusable(true);
        this.setRequestFocusEnabled(false);
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setOrientation(int n) {
        int n2 = this._orientation;
        if (n2 != n) {
            this._orientation = n;
            this.firePropertyChange("orientation", n2, n);
        }
    }

    public boolean supportVerticalOrientation() {
        return true;
    }

    public boolean supportHorizontalOrientation() {
        return true;
    }

    public int getButtonStyle() {
        return this._buttonStyle;
    }

    public void setButtonStyle(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Only TOOLBAR_STYLE, TOOLBOX_STYLE, FLAT_STYLE and HYPERLINK_STYLE are supported");
        }
        if (n == this._buttonStyle) {
            return;
        }
        int n2 = this._buttonStyle;
        this._buttonStyle = n;
        this.firePropertyChange("buttonStyle", n2, this._buttonStyle);
    }

    public boolean isAlwaysShowHyperlink() {
        return this._alwaysShowHyperlink;
    }

    public void setAlwaysShowHyperlink(boolean bl) {
        if (this._alwaysShowHyperlink != bl) {
            boolean bl2 = this._alwaysShowHyperlink;
            this._alwaysShowHyperlink = bl;
            this.firePropertyChange(PROPERTY_ALWAYS_SHOW_HYPERLINK, bl2, bl);
        }
    }

    public Cursor getCursor() {
        if (this.getButtonStyle() == 3 && this.isRolloverEnabled() && this.getModel().isRollover() && (this.getText() != null && this.getText().length() > 0 || this.getIcon() != null)) {
            return Cursor.getPredefinedCursor(12);
        }
        return super.getCursor();
    }

    public Color getDefaultForeground() {
        return this._defaultForeground;
    }

    public void setDefaultForeground(Color color) {
        this._defaultForeground = color;
    }

    private Color getRolloverBackground() {
        return this._rolloverBackground;
    }

    private void setRolloverBackground(Color color) {
        this._rolloverBackground = color;
    }

    private Color getSelectedBackground() {
        return this._selectedBackground;
    }

    private void setSelectedBackground(Color color) {
        this._selectedBackground = color;
    }

    private Color getPressedBackground() {
        return this._pressedBackground;
    }

    private void setPressedBackground(Color color) {
        this._pressedBackground = color;
    }

    private Color getRolloverForeground() {
        return this._rolloverForeground;
    }

    private void setRolloverForeground(Color color) {
        this._rolloverForeground = color;
    }

    private Color getSelectedForeground() {
        return this._selectedForeground;
    }

    private void setSelectedForeground(Color color) {
        this._selectedForeground = color;
    }

    private Color getPressedForeground() {
        return this._pressedForeground;
    }

    private void setPressedForeground(Color color) {
        this._pressedForeground = color;
    }

    public Color getBackgroundOfState(int n) {
        switch (n) {
            case 0: {
                return this.getBackground();
            }
            case 2: {
                return this.getRolloverBackground();
            }
            case 3: {
                return this.getSelectedBackground();
            }
            case 1: {
                return this.getPressedBackground();
            }
        }
        return null;
    }

    public void setBackgroundOfState(int n, Color color) {
        switch (n) {
            case 0: {
                this.setBackground(color);
                break;
            }
            case 2: {
                this.setRolloverBackground(color);
                break;
            }
            case 3: {
                this.setSelectedBackground(color);
                break;
            }
            case 1: {
                this.setPressedBackground(color);
            }
        }
    }

    public Color getForegroundOfState(int n) {
        switch (n) {
            case 0: {
                return this.getDefaultForeground();
            }
            case 2: {
                return this.getRolloverForeground();
            }
            case 3: {
                return this.getSelectedForeground();
            }
            case 1: {
                return this.getPressedForeground();
            }
        }
        return null;
    }

    public void setForegroundOfState(int n, Color color) {
        switch (n) {
            case 0: {
                this.setDefaultForeground(color);
                break;
            }
            case 2: {
                this.setRolloverForeground(color);
                break;
            }
            case 3: {
                this.setSelectedForeground(color);
                break;
            }
            case 1: {
                this.setPressedForeground(color);
            }
        }
    }
}

