/*
 * Decompiled with CFR 0.152.
 */
package gr.gsis.fmy.desktop.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;

public class Utils {
    public static final String xml = "xml";
    public static final String pdf = "pdf";
    public static final String jpg = "jpg";
    public static final String jpeg = "jpeg";
    public static final String tiff = "tiff";
    public static final String tif = "tif";
    public static final String zip = "zip";
    public static final String xls = "xls";
    public static final String xlsx = "xlsx";

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String substituteString(String texttbp, String stbefore, String stafter) {
        String tbptext = texttbp;
        int i = 0;
        boolean j = false;
        while (tbptext.indexOf(stbefore) != -1) {
            i = tbptext.indexOf(stbefore);
            String part1 = tbptext.substring(0, i);
            String part2 = tbptext.substring(part1.length() + stbefore.length(), tbptext.length());
            tbptext = part1 + stafter + part2;
        }
        return tbptext;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = Utils.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public static boolean checkAMKA(String amka) {
        int i;
        if (amka == null) {
            return false;
        }
        int[] amkadigits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        boolean amkachk = true;
        boolean amkachkletter = true;
        boolean amkachkday = true;
        boolean amkachkmonth = true;
        int sum = 0;
        for (i = 0; i < amka.length(); ++i) {
            if (Character.isDigit(amka.charAt(i))) continue;
            amkachkletter = false;
        }
        if (amkachkletter) {
            if (amka.length() != 11 || amka.equals("")) {
                amkachk = false;
                amkachkletter = false;
            } else {
                for (i = 0; i < 10; ++i) {
                    amkadigits[i] = Integer.valueOf(amka.substring(i, i + 1));
                    if (i % 2 == 1) {
                        if (amkadigits[i] < 5) {
                            sum += amkadigits[i] * 2;
                            continue;
                        }
                        sum = sum + 1 + amkadigits[i] * 2 % 10;
                        continue;
                    }
                    sum += amkadigits[i];
                }
                int checkDigit = Integer.valueOf(amka.substring(10, 11));
                int ypol = 10 - sum % 10;
                if (ypol == 10 && checkDigit != 0 || ypol != 10 && ypol != checkDigit) {
                    amkachk = false;
                }
            }
            if (amkachk && amkachkletter) {
                int month;
                int day = Integer.valueOf(amka.substring(0, 2));
                if (day > 31 || day < 0) {
                    amkachkday = false;
                }
                if ((month = Integer.valueOf(amka.substring(2, 4)).intValue()) > 12 || month < 1) {
                    amkachkmonth = false;
                }
            }
        }
        boolean result = amkachk && amkachkletter && amkachkday && amkachkmonth;
        return result;
    }

    public static void createFiles(File f) {
        try {
            if (!f.getParentFile().exists()) {
                Utils.createParents(f.getParentFile());
                f.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createParents(File file) {
        if (!file.exists()) {
            Utils.createParents(file.getParentFile());
            file.mkdir();
        }
    }

    public static void copyfile(File f1, File f2) {
        try {
            int len;
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            System.out.println("File copied.");
        }
        catch (FileNotFoundException ex) {
            System.out.println(ex.getMessage() + " in the specified directory.");
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static boolean unzip(ZipInputStream zis, String dir_for_output, Enumeration entries) {
        try {
            int len;
            ZipEntry entry = zis.getNextEntry();
            if (entry == null) {
                zis.close();
                return true;
            }
            ZipEntry ent = (ZipEntry)entries.nextElement();
            int size = (int)ent.getSize();
            String filename = dir_for_output + File.separatorChar + entry.getName();
            Utils.createFiles(new File(filename));
            FileOutputStream fos = new FileOutputStream(filename);
            byte[] buffer = new byte[65535];
            while ((len = zis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
            fos.flush();
            fos.close();
            boolean resultOfMoreCalls = Utils.unzip(zis, dir_for_output, entries);
            if (!resultOfMoreCalls) {
                return false;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean inDateRange(Calendar dateToBeChecked, Calendar dateFrom, Calendar dateTo) {
        if (dateToBeChecked == null) {
            return false;
        }
        return dateToBeChecked.compareTo(dateFrom) >= 0 && dateToBeChecked.compareTo(dateTo) <= 0;
    }

    public static boolean checkAFM(String afm) {
        int i;
        if (afm == null) {
            return false;
        }
        String chkafm = "afm accepted";
        int[] afmdigits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        boolean afmchk = true;
        boolean afmchkletter = true;
        boolean afmchkdigit = true;
        int sum = 0;
        for (i = 0; i < afm.length(); ++i) {
            if (Character.isDigit(afm.charAt(i))) continue;
            afmchkletter = false;
        }
        if (afmchkletter) {
            if (afm.length() != 9 || afm.equals("")) {
                afmchk = false;
                afmchkdigit = false;
            } else {
                for (i = 0; i < 8; ++i) {
                    afmdigits[i] = Integer.valueOf(afm.substring(i, i + 1));
                    sum += afmdigits[i] * (int)Math.pow(2.0, 8 - i);
                }
                afmdigits[8] = Integer.valueOf(afm.substring(8, 9));
                int ypol = sum % 11;
                if (ypol == 10 && afmdigits[8] != 0 || ypol < 10 && ypol != afmdigits[8]) {
                    afmchk = false;
                }
            }
        }
        boolean result = afmchk && afmchkletter && afmchkdigit;
        return result;
    }

    public static boolean checkDate(String dateString) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            Date dat1 = sdf.parse(dateString);
            return true;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean checkInt(String intString) {
        try {
            Integer.parseInt(intString);
            return true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Date toMidnight(Date incomingDate) throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(incomingDate);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static String convertCharsets(String fromCharset, String toCharset, String instring) {
        String outstring = "";
        if (instring == null) {
            return instring;
        }
        byte[] bs = null;
        try {
            bs = instring.getBytes(fromCharset);
            outstring = new String(bs, toCharset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return outstring;
    }

    public static boolean isBeforeDeadline(Date deadline) {
        Calendar deadlineCal = Calendar.getInstance();
        deadlineCal.setTime(deadline);
        Calendar currentDate = Calendar.getInstance();
        currentDate.setTime(new Date());
        return !currentDate.after(deadlineCal);
    }

    public static String removeAccents(String lexi) {
        while (lexi.indexOf("\u00a2") >= 0 || lexi.indexOf("\u00b8") >= 0 || lexi.indexOf("\u00b9") >= 0 || lexi.indexOf("\u00ba") >= 0 || lexi.indexOf("\u00bc") >= 0 || lexi.indexOf("\u00be") >= 0 || lexi.indexOf("\u00bf") >= 0) {
            if (lexi.indexOf("\u00a2") >= 0) {
                lexi = Utils.removeOneAccent(lexi, "\u00a2", "\u00c1");
                continue;
            }
            if (lexi.indexOf("\u00b8") >= 0) {
                lexi = Utils.removeOneAccent(lexi, "\u00b8", "\u00c5");
                continue;
            }
            if (lexi.indexOf("\u00b9") >= 0) {
                lexi = Utils.removeOneAccent(lexi, "\u00b9", "\u00c7");
                continue;
            }
            if (lexi.indexOf("\u00ba") >= 0) {
                lexi = Utils.removeOneAccent(lexi, "\u00ba", "\u00c9");
                continue;
            }
            if (lexi.indexOf("\u00bc") >= 0) {
                lexi = Utils.removeOneAccent(lexi, "\u00bc", "\u00cf");
                continue;
            }
            if (lexi.indexOf("\u00be") >= 0) {
                lexi = Utils.removeOneAccent(lexi, "\u00be", "\u00d5");
                continue;
            }
            if (lexi.indexOf("\u00bf") < 0) continue;
            lexi = Utils.removeOneAccent(lexi, "\u00bf", "\u00d9");
        }
        return lexi;
    }

    public static String removeOneAccent(String lexi, String gramma, String neogramma) {
        while (lexi.indexOf(gramma) >= 0) {
            lexi = lexi.substring(0, lexi.indexOf(gramma)) + neogramma + lexi.substring(lexi.indexOf(gramma) + 1, lexi.length());
        }
        return lexi;
    }
}

