/*
 * Decompiled with CFR 0.152.
 */
package gsis.utils;

import java.awt.Toolkit;
import java.text.DecimalFormat;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class ValueField
extends JFormattedTextField {
    static Toolkit toolkit;

    public ValueField() {
        toolkit = Toolkit.getDefaultToolkit();
    }

    protected Document createDefaultModel() {
        return new ValueDocument();
    }

    static class ValueDocument
    extends PlainDocument {
        ValueDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String old = this.getText(0, this.getLength());
            boolean valid = false;
            String newStr = old.substring(0, offs) + str + old.substring(offs);
            if (str == null) {
                return;
            }
            char[] upper = str.toCharArray();
            for (int i = 0; i < upper.length; ++i) {
                upper[i] = Character.toUpperCase(upper[i]);
            }
            valid = this.isValid(newStr);
            if (valid) {
                super.insertString(offs, new String(upper), a);
            } else {
                toolkit.beep();
            }
        }

        public boolean isValid(String str) {
            String valstring;
            DecimalFormat formatter = new DecimalFormat("0.00");
            try {
                valstring = formatter.format(Double.parseDouble(this.substituteString(str, ",", ".")));
            }
            catch (NumberFormatException e) {
                return false;
            }
            return valstring.indexOf(",") <= 14 && valstring.length() <= 17;
        }

        protected String substituteString(String texttbp, String stbefore, String stafter) {
            String tbptext = texttbp;
            int i = 0;
            boolean j = false;
            while (tbptext.indexOf(stbefore) != -1) {
                i = tbptext.indexOf(stbefore);
                String part1 = tbptext.substring(0, i);
                String part2 = tbptext.substring(part1.length() + stbefore.length(), tbptext.length());
                tbptext = part1 + stafter + part2;
            }
            return tbptext;
        }
    }
}

